function varargout = stk_filter_gui(varargin)
% STK_FILTER_GUI M-file for stk_filter_gui.fig
%      STK_FILTER_GUI, by itself, creates a new STK_FILTER_GUI or raises the existing
%      singleton*.
%
%      H = STK_FILTER_GUI returns the handle to a new STK_FILTER_GUI or the handle to
%      the existing singleton*.
%
%      STK_FILTER_GUI('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in STK_FILTER_GUI.M with the given input arguments.
%
%      STK_FILTER_GUI('Property','Value',...) creates a new STK_FILTER_GUI or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before stk_filter_gui_OpeningFunction gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to stk_filter_gui_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help stk_filter_gui

% Last Modified by GUIDE v2.5 29-Nov-2006 14:37:06

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @stk_filter_gui_OpeningFcn, ...
                   'gui_OutputFcn',  @stk_filter_gui_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before stk_filter_gui is made visible.
function stk_filter_gui_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to stk_filter_gui (see VARARGIN)

% Choose default command line output for stk_filter_gui
handles.output = hObject;

%Initialize
handles.button_state = 0;       %Allow the button press to output its own data/TTL
handles.quit = 0;               %Allow the GUI to close itself

h = guihandles(hObject);                 %Get all the handles for all gui elements, guidata will work here too

img_ptr = 1;   %default value.
handles.stk = [];   %no stack yet

%Parse Varargin
if ~isempty(varargin)
    a = size(varargin,2);
    for i = 1:2:a
        b = varargin{1,i+1};
        switch varargin{1,i}
            case 'position'
                if ischar(b)
                   movegui(h.figure1,b);        %center the gui on screen
                else
                   error(['Error: You must enter a string for property: position, e.g., center,north,south,east,west...']);
                end
            case 'stack'        %Note: the stack property must be entered before the frame property.
                if isnumeric(b)
                    handles.stk = b;
                    %default image setup
                    handles.orig_img = handles.stk(:,:,1);
                    handles.img_width = size(handles.stk(:,:,1),2);
                    handles.img_length = size(handles.stk(:,:,1),1);
                else
                    error(['Error: You must enter an image stack for the stack parameter.']);
                end
            case 'range'        %Note: the stack property must be entered before the frame property.
                if isnumeric(b)
                    handles.range = b;
                else
                    error(['Error: range is the range array generated by stack or stack_gui.']);
                end
            case 'frame'
                if isnumeric(b)
                    handles.orig_img = handles.stk(:,:,b);  %allow you to enter the specific frame you want to be displayed
                    handles.img_width = size(handles.stk(:,:,b),2);
                    handles.img_length = size(handles.stk(:,:,b),1);
                    img_ptr = b;   %a pointer to the frame # in the image stack
                else
                    error(['Error: You must enter a scalar for the frame number, e.g., 1']);
                end
        end
    end
end

%stack verification
if isempty(handles.stk) %if no input stack, prompt the user to open one.
    [handles.stk,handles.range] = stack_gui;
end

%set frames list for the frame selection drop box create frame list
flist = [1:size(handles.stk,3)]';   %create and transpose the file list
flist = num2str(flist);     %convert to string
flist = cellstr(flist);     %convert to cell array
set(h.frame_num_menu,'String',flist);
set(h.frame_num_menu,'Value',img_ptr);

%display the images
%Display the first image
axes(h.original)
image(handles.img_width,handles.img_length,handles.orig_img);
colormap(gray(256));
set(h.original,'Visible','off','Units','pixels');

%apply default filter and show first changed image
handles.demo_img = medfilt2(handles.orig_img,[2 2]);
axes(h.filtered)
image(handles.img_width,handles.img_length,handles.demo_img);
colormap(gray(256));
set(h.filtered,'Visible','off','Units','pixels');

handles.range_ext = 0;  %default range_ext is off.

%filter parameter string cell array values set and save
handles.filter_param_menu_string_neighbor = get(h.filter_param_menu,'String');
handles.filter_param_menu_str_alpha = cellstr(num2str([0:0.1:1]'));
handles.neighbor = [2 2];
handles.neighbor_value = 1;
handles.filter_type = 1;    %1 = median, 2 = adaptive, 3 = difference

%initialize the boundary value.
handles.boundary = 0;

%filter options
handles.sigma = 0.5;
handles.theta = 0;
handles.radius = 4;
handles.alpha = 6;
handles.len = 8;

%set up the range limits for range extend
handles.new_lim = 256;
handles.old_lim = max(max(handles.range));

%store a copy of all the gui handles in the handles structure
handles.h = h;

% Update handles structure
guidata(hObject, handles);

% UIWAIT makes stk_filter_gui wait for user response (see UIRESUME)
uiwait(handles.figure1);


% --- Outputs from this function are returned to the command line.
function varargout = stk_filter_gui_OutputFcn(hObject, eventdata, handles) 
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.stk;

q = handles.quit;
if q==1
    delete(handles.figure1);
end

% --- Executes on button press in done_button.
function done_button_Callback(hObject, eventdata, handles)
% hObject    handle to done_button (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
handles.button_state = 1;
handles.quit = 1;

%Create the final syntax for stk_filter and apply it to the stack
switch handles.filter_type
    case 1
        handles.stk = stk_filter(handles.stk,'median',handles.neighbor);
    case 2
        handles.stk = stk_filter(handles.stk,'adaptive',handles.neighbor);
    case 3
        handles.stk = stk_filter(handles.stk,'manual',handles.filter,...
            handles.boundary_str,handles.filter_opt_str,'same');
end

%range extend or not
if handles.range_ext
    handles.stk = stk_filter(handles.stk,'range_ext',handles.new_lim,handles.old_lim);
end

%store data
guidata(hObject, handles);
uiresume;

% --- Executes on button press in cancel_button.
function cancel_button_Callback(hObject, eventdata, handles)
% hObject    handle to cancel_button (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
handles.button_state = 1;
handles.quit = 1;

%store data
guidata(hObject, handles);
uiresume;

% --- Executes on button press in median_button.
function median_button_Callback(hObject, eventdata, handles)
% hObject    handle to median_button (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of median_button

if get(hObject,'Value') %true if select
    handles.filter_type = 1;
    %set values for other UI objects
    set(handles.adaptive_button,'Value',0);
    set(handles.manual_filter_button,'Value',0);
    set(handles.filter_param_menu,'Value',handles.neighbor_value);
    set(handles.filter_param_menu,'Visible','on');
    set(handles.filter_param_menu,'String',handles.filter_param_menu_string_neighbor);
    set(handles.filter_param_menu,'TooltipString',...
        'Neighborhood Size: 2 =  2x2, or a grid of pixels 2 pixels by 2 pixels.');
    set(handles.filter_param_txt,'Visible','on');
    set(handles.filter_param_txt,'String','Neighborhood Size');
    set(handles.info_txt,'String',...
        'Median filtering: the value of an output pixel is determined by the median of the neighborhood pixels.');
    set(handles.gain_box,'Visible','on');
    set(handles.gain_box,'TooltipString',...
        ['Automatic: extends the dynamic range of the stack to the full spectrum.']);
    set(handles.filter_type_txt,'Visible','off');
    set(handles.filter_type_menu,'Visible','off');
    set(handles.boundary_txt,'Visible','off');
    set(handles.boundary_menu,'Visible','off');
    set(handles.boundary_edit_txt,'Visible','off');
    set(handles.filter_opt_txt,'Visible','off');
    set(handles.filter_opt_menu,'Visible','off');
    set(handles.filter_type_opt_txt,'Visible','off');
    set(handles.filter_type_edit_txt,'Visible','off');
    %get parameter settings
    neighbor = str2num(handles.filter_param_menu_string_neighbor{get(handles.filter_param_menu,'Value')});
    handles.neighbor = [neighbor neighbor];
    %show preview
    handles.demo_img = medfilt2(handles.orig_img,handles.neighbor);
    %extend dynamic range
    if get(handles.gain_box,'Value')
        handles.demo_img = rangemax(handles.demo_img,handles.new_lim,handles.old_lim);
    end
    axes(handles.filtered)
    image(handles.img_width,handles.img_length,handles.demo_img);
    colormap(gray(256));
    set(handles.filtered,'Visible','off','Units','pixels');
else    %false if unselect
    if get(handles.adaptive_button,'Value')==0 && get(handles.manual_filter_button,'Value')==0
        %no filter is selected, which is not allowed
        set(hObject,'Value',1);
    end
end

% Update handles structure
guidata(hObject, handles);

% --- Executes on button press in adaptive_button.
function adaptive_button_Callback(hObject, eventdata, handles)
% hObject    handle to adaptive_button (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of adaptive_button

if get(hObject,'Value') %true if select
    handles.filter_type = 2;
    %set values for other UI objects
    set(handles.median_button,'Value',0);
    set(handles.manual_filter_button,'Value',0);
    set(handles.filter_param_menu,'Value',handles.neighbor_value);
    set(handles.filter_param_menu,'Visible','on');
    set(handles.filter_param_menu,'String',handles.filter_param_menu_string_neighbor);
    set(handles.filter_param_menu,'TooltipString',...
        'Neighborhood Size: 2 =  2x2, or a grid of pixels 2 pixels by 2 pixels.');
    set(handles.filter_param_txt,'Visible','on');
    set(handles.filter_param_txt,'String','Neighborhood Size');
    set(handles.info_txt,'String',...
        'Adaptive filtering: filter tailors itself to the local image variance. Best for Gaussian Noise');
    set(handles.gain_box,'Visible','on');
    set(handles.gain_box,'TooltipString',...
        ['Automatic: extends the dynamic range of the stack to the full spectrum.']);
        set(handles.filter_type_txt,'Visible','off');
    set(handles.filter_type_menu,'Visible','off');
    set(handles.boundary_txt,'Visible','off');
    set(handles.boundary_menu,'Visible','off');
    set(handles.boundary_edit_txt,'Visible','off');
    set(handles.filter_opt_txt,'Visible','off');
    set(handles.filter_opt_menu,'Visible','off');
    set(handles.filter_type_opt_txt,'Visible','off');
    set(handles.filter_type_edit_txt,'Visible','off');
    %get parameter settings
    neighbor = str2num(handles.filter_param_menu_string_neighbor{get(handles.filter_param_menu,'Value')});
    handles.neighbor = [neighbor neighbor];
    %show preview
    handles.demo_img = wiener2(handles.orig_img,handles.neighbor);
    %extend dynamic range
    if get(handles.gain_box,'Value')
        handles.demo_img = rangemax(handles.demo_img,handles.new_lim,handles.old_lim);
    end
    axes(handles.filtered)
    image(handles.img_width,handles.img_length,handles.demo_img);
    colormap(gray(256));
    set(handles.filtered,'Visible','off','Units','pixels');
else    %false if unselect
    if get(handles.median_button,'Value')==0 && get(handles.manual_filter_button,'Value')==0
        %no filter is selected, which is not allowed
        set(hObject,'Value',1);
    end
end

% Update handles structure
guidata(hObject, handles);

% --- Executes on button press in manual_filter_button.
function manual_filter_button_Callback(hObject, eventdata, handles)
% hObject    handle to manual_filter_button (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of manual_filter_button

if get(hObject,'Value') %true if select
    handles.filter_type = 3;
    %set values for other UI objects
    set(handles.median_button,'Value',0);
    set(handles.adaptive_button,'Value',0);
    switch get(handles.filter_type_menu,'Value');
        case {1,3,5}
            set(handles.filter_param_menu,'Value',handles.neighbor_value);
            set(handles.filter_param_menu,'Visible','on');
            set(handles.filter_param_menu,'String',handles.filter_param_menu_string_neighbor);
            set(handles.filter_param_menu,'TooltipString',...
                'Neighborhood Size: 2 =  2x2, or a grid of pixels 2 pixels by 2 pixels.');
            set(handles.filter_param_txt,'Visible','on');
            set(handles.filter_param_txt,'String','Neighborhood Size');
        case 2
            set(handles.filter_param_menu,'Value',handles.radius);
            set(handles.filter_param_menu,'Visible','on');
            set(handles.filter_param_menu,'String',handles.filter_param_menu_string_neighbor);
            set(handles.filter_param_menu,'TooltipString',...
                'Radius of the circular averaging filter (Pillbox).');
            set(handles.filter_param_txt,'Visible','on');
            set(handles.filter_param_txt,'String','Radius');
        case {4,9}
            set(handles.filter_param_menu,'Value',handles.alpha);
            set(handles.filter_param_menu,'Visible','on');
            set(handles.filter_param_menu,'String',handles.filter_param_menu_str_alpha);
            set(handles.filter_param_menu,'TooltipString',...
                'Alpha controls the shape of the Laplacian and must be in the range 0.0 to 1.0.');
            set(handles.filter_param_txt,'Visible','on');
            set(handles.filter_param_txt,'String','Alpha');
        case 6
            set(handles.filter_param_menu,'Value',handles.len);
            set(handles.filter_param_menu,'Visible','on');
            set(handles.filter_param_menu,'String',handles.filter_param_menu_string_neighbor);
            set(handles.filter_param_menu,'TooltipString',...
                'Convolve the image to create the linear motion of a camera by length pixels');
            set(handles.filter_param_txt,'Visible','on');
            set(handles.filter_param_txt,'String','Length');
        case {7,8}
            set(handles.filter_param_menu,'Visible','off');
            set(handles.filter_param_txt,'Visible','off');
    end
    set(handles.info_txt,'String',...
        'Manual filtering: More control over the filtering. Look up imfilter function for more detail.');
    set(handles.gain_box,'Visible','on');
    set(handles.gain_box,'TooltipString',...
        ['Automatic: extends the dynamic range of the stack to the full spectrum.']);
    set(handles.filter_type_txt,'Visible','off');
    set(handles.filter_type_menu,'Visible','on');
    set(handles.boundary_txt,'Visible','on');
    set(handles.boundary_menu,'Visible','on');
    if get(handles.boundary_menu,'Value')==1;
        set(handles.boundary_edit_txt,'Visible','on');
    end
    set(handles.filter_opt_txt,'Visible','on');
    set(handles.filter_opt_menu,'Visible','on');
    switch get(handles.filter_type_menu,'Value')
        case {3,5}
            set(handles.filter_type_opt_txt,'Visible','on');
            set(handles.filter_type_edit_txt,'Visible','on');
            set(handles.filter_type_opt_txt,'String','Sigma');
            set(handles.filter_type_edit_txt,'Value',handles.sigma);
            set(handles.filter_type_edit_txt,'String',num2str(handles.sigma));
            set(handles.filter_type_edit_txt,'TooltipString',...
                'Sigma is the standard deviation of the lowpass Gausian Function');
        case 6
            set(handles.filter_type_opt_txt,'Visible','on');
            set(handles.filter_type_edit_txt,'Visible','on');
            set(handles.filter_type_opt_txt,'String','Theta');
            set(handles.filter_type_edit_txt,'Value',handles.theta);
            set(handles.filter_type_edit_txt,'String',num2str(handles.theta));
            set(handles.filter_type_edit_txt,'TooltipString',...
                'Theta is the angle of motion, 0 = horizontal.');
        otherwise
            set(handles.filter_type_opt_txt,'Visible','off');
            set(handles.filter_type_edit_txt,'Visible','off');
    end
    %get parameter settings
    %set up fspecial to create the filter
    switch get(handles.filter_type_menu,'Value');
        case 1
            neighbor = str2num(handles.filter_param_menu_string_neighbor{get(handles.filter_param_menu,'Value')});
            handles.neighbor = [neighbor neighbor];
            filter_str = get(handles.filter_type_menu,'String');
            filter_str = filter_str{get(handles.filter_type_menu,'Value')};
            handles.filter = fspecial(filter_str,handles.neighbor);
        case {3,5}
            neighbor = str2num(handles.filter_param_menu_string_neighbor{get(handles.filter_param_menu,'Value')});
            handles.neighbor = [neighbor neighbor];
            filter_str = get(handles.filter_type_menu,'String');
            filter_str = filter_str{get(handles.filter_type_menu,'Value')};
            handles.filter = fspecial(filter_str,handles.neighbor,handles.sigma);
        case 2
            radius = str2num(handles.filter_param_menu_string_neighbor{handles.radius});
            filter_str = get(handles.filter_type_menu,'String');
            filter_str = filter_str{get(handles.filter_type_menu,'Value')};
            handles.filter = fspecial(filter_str,radius);
        case {4,9}
            alpha = str2num(handles.filter_param_menu_str_alpha{handles.alpha});
            filter_str = get(handles.filter_type_menu,'String');
            filter_str = filter_str{get(handles.filter_type_menu,'Value')};
            handles.filter = fspecial(filter_str,alpha);
        case 6
            len = str2num(handles.filter_param_menu_string_neighbor{handles.len});
            filter_str = get(handles.filter_type_menu,'String');
            filter_str = filter_str{get(handles.filter_type_menu,'Value')};
            handles.filter = fspecial(filter_str,len,handles.theta);
        case {7,8}
            filter_str = get(handles.filter_type_menu,'String');
            filter_str = filter_str{get(handles.filter_type_menu,'Value')};
            handles.filter = fspecial(filter_str);
    end
    %set up the boundary conditions
    if get(handles.boundary_menu,'Value')==1
        handles.boundary_str = handles.boundary;
    else
        handles.boundary_str = get(handles.boundary_menu,'String');
        handles.boundary_str = handles.boundary_str{get(handles.boundary_menu,'Value')};
    end
    %set up the filtering option
    handles.filter_opt_str = get(handles.filter_opt_menu,'String');
    handles.filter_opt_str = handles.filter_opt_str{get(handles.filter_opt_menu,'Value')};
    %show preview
    handles.demo_img = imfilter(handles.orig_img,handles.filter,handles.boundary_str,handles.filter_opt_str,'same');
    %extend the dynamic range
    if get(handles.gain_box,'Value')
        handles.demo_img = rangemax(handles.demo_img,handles.new_lim,handles.old_lim);
    end
    axes(handles.filtered)
    image(handles.img_width,handles.img_length,handles.demo_img);
    colormap(gray(256));
    set(handles.filtered,'Visible','off','Units','pixels');
else    %false if unselect
    if get(handles.median_button,'Value')==0 && get(handles.adaptive_button,'Value')==0
        %no filter is selected, which is not allowed
        set(hObject,'Value',1);
    end
end

% Update handles structure
guidata(hObject, handles);

% --- Executes on selection change in filter_param_menu.
function filter_param_menu_Callback(hObject, eventdata, handles)
% hObject    handle to filter_param_menu (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = get(hObject,'String') returns filter_param_menu contents as cell array
%        contents{get(hObject,'Value')} returns selected item from filter_param_menu

switch handles.filter_type
    case {1,2}    %neighbor
        neighbor = str2num(handles.filter_param_menu_string_neighbor{get(hObject,'Value')});
        handles.neighbor = [neighbor neighbor];
        handles.neighbor_value = get(hObject,'Value');
    case 3
        handles.neighbor_value = get(hObject,'Value');
        filter_str = get(handles.filter_type_menu,'String');
        filter_str = filter_str{get(handles.filter_type_menu,'Value')};
        switch get(handles.filter_type_menu,'Value');
            case {1,3,5}
                neighbor = str2num(handles.filter_param_menu_string_neighbor{get(hObject,'Value')});
                handles.neighbor = [neighbor neighbor];
                handles.neighbor_value = get(hObject,'Value');
                if get(handles.filter_type_menu,'Value')==1
                    handles.filter = fspecial(filter_str,handles.neighbor);
                else
                    handles.filter = fspecial(filter_str,handles.neighbor,handles.sigma);
                end
            case {4,9}
                alpha = str2num(handles.filter_param_menu_str_alpha{get(hObject,'Value')});
                handles.filter = fspecial(filter_str,alpha);
                handles.alpha = get(hObject,'Value');
            case 2
                radius = str2num(handles.filter_param_menu_string_neighbor{get(hObject,'Value')});
                handles.filter = fspecial(filter_str,radius);
                handles.radius = get(hObject,'Value');
            case 6
                len = str2num(handles.filter_param_menu_string_neighbor{get(hObject,'Value')});
                handles.filter = fspecial(filter_str,len,handles.theta);
                handles.len = get(hObject,'Value');
        end
end

switch handles.filter_type
    case 1
        handles.demo_img = medfilt2(handles.orig_img,handles.neighbor);
    case 2
        handles.demo_img = wiener2(handles.orig_img,handles.neighbor);
    case 3
        handles.demo_img = imfilter(handles.orig_img,handles.filter,handles.boundary_str,handles.filter_opt_str,'same');
end
if get(handles.gain_box,'Value')
    handles.demo_img = rangemax(handles.demo_img,handles.new_lim,handles.old_lim);
end
axes(handles.filtered)
image(handles.img_width,handles.img_length,handles.demo_img);
colormap(gray(256));
set(handles.filtered,'Visible','off','Units','pixels');

% Update handles structure
guidata(hObject, handles);

% --- Executes during object creation, after setting all properties.
function filter_param_menu_CreateFcn(hObject, eventdata, handles)
% hObject    handle to filter_param_menu (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end




% --- Executes on selection change in frame_num_menu.
function frame_num_menu_Callback(hObject, eventdata, handles)
% hObject    handle to frame_num_menu (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = get(hObject,'String') returns frame_num_menu contents as cell array
%        contents{get(hObject,'Value')} returns selected item from frame_num_menu

frame_num = get(hObject,'Value');
handles.orig_img = handles.stk(:,:,frame_num);

%Display the first image
axes(handles.original)
image(handles.img_width,handles.img_length,handles.orig_img);
colormap(gray(256));
set(handles.original,'Visible','off','Units','pixels');

%apply default filter and show first changed image
switch handles.filter_type
    case 1
        handles.demo_img = medfilt2(handles.orig_img,handles.neighbor);
    case 2
        handles.demo_img = wiener2(handles.orig_img,handles.neighbor);
    case 3
        handles.demo_img = imfilter(handles.orig_img,handles.filter,handles.boundary_str,handles.filter_opt_str,'same');
end
if get(handles.gain_box,'Value')
    handles.demo_img = rangemax(handles.demo_img,handles.new_lim,handles.old_lim);
end
axes(handles.filtered)
image(handles.img_width,handles.img_length,handles.demo_img);
colormap(gray(256));
set(handles.filtered,'Visible','off','Units','pixels');

% Update handles structure
guidata(hObject, handles);

% --- Executes during object creation, after setting all properties.
function frame_num_menu_CreateFcn(hObject, eventdata, handles)
% hObject    handle to frame_num_menu (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



% --- Executes on button press in gain_box.
function gain_box_Callback(hObject, eventdata, handles)
% hObject    handle to gain_box (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of gain_box

if get(hObject,'Value') %gain selected
    handles.range_ext = 1;
    handles.demo_img = rangemax(handles.demo_img,handles.new_lim,handles.old_lim);
    axes(handles.filtered)
    image(handles.img_width,handles.img_length,handles.demo_img);
    colormap(gray(256));
    set(handles.filtered,'Visible','off','Units','pixels');

else    %gain off
    handles.range_ext = 0;
    switch handles.filter_type
        case 1
            handles.demo_img = medfilt2(handles.orig_img,handles.neighbor);
        case 2
            handles.demo_img = wiener2(handles.orig_img,handles.neighbor);
        case 3
            handles.demo_img = imfilter(handles.orig_img,handles.filter,handles.boundary_str,handles.filter_opt_str,'same');
    end
    axes(handles.filtered)
    image(handles.img_width,handles.img_length,handles.demo_img);
    colormap(gray(256));
    set(handles.filtered,'Visible','off','Units','pixels');
end

% Update handles structure
guidata(hObject, handles);

% --- Executes on selection change in filter_type_menu.
function filter_type_menu_Callback(hObject, eventdata, handles)
% hObject    handle to filter_type_menu (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = get(hObject,'String') returns filter_type_menu contents as cell array
%        contents{get(hObject,'Value')} returns selected item from filter_type_menu
switch get(hObject,'Value');
    case 1
        set(handles.filter_param_menu,'Value',handles.neighbor_value);
        set(handles.filter_param_menu,'Visible','on');
        set(handles.filter_param_menu,'String',handles.filter_param_menu_string_neighbor);
        set(handles.filter_param_menu,'TooltipString',...
            'Neighborhood Size: 2 =  2x2, or a grid of pixels 2 pixels by 2 pixels.');
        set(handles.filter_param_txt,'Visible','on');
        set(handles.filter_param_txt,'String','Neighborhood Size');
        set(handles.filter_type_edit_txt,'Visible','off');
        set(handles.filter_type_opt_txt,'Visible','off');
        neighbor = str2num(handles.filter_param_menu_string_neighbor{get(handles.filter_param_menu,'Value')});
        handles.neighbor = [neighbor neighbor];
        filter_str = get(handles.filter_type_menu,'String');
        filter_str = filter_str{get(handles.filter_type_menu,'Value')};
        handles.filter = fspecial(filter_str,handles.neighbor);
    case {3,5}
        set(handles.filter_param_menu,'Value',handles.neighbor_value);
        set(handles.filter_param_menu,'Visible','on');
        set(handles.filter_param_menu,'String',handles.filter_param_menu_string_neighbor);
        set(handles.filter_param_menu,'TooltipString',...
            'Neighborhood Size: 2 =  2x2, or a grid of pixels 2 pixels by 2 pixels.');
        set(handles.filter_param_txt,'Visible','on');
        set(handles.filter_param_txt,'String','Neighborhood Size');
        set(handles.filter_type_opt_txt,'Visible','on');
        set(handles.filter_type_edit_txt,'Visible','on');
        set(handles.filter_type_opt_txt,'String','Sigma');
        set(handles.filter_type_edit_txt,'Value',handles.sigma);
        set(handles.filter_type_edit_txt,'String',num2str(handles.sigma));
        set(handles.filter_type_edit_txt,'TooltipString',...
            'Sigma is the standard deviation of the lowpass Gausian Function');
        set(handles.filter_type_edit_txt,'Visible','on');
        set(handles.filter_type_opt_txt,'Visible','on');
        neighbor = str2num(handles.filter_param_menu_string_neighbor{get(handles.filter_param_menu,'Value')});
        handles.neighbor = [neighbor neighbor];
        filter_str = get(handles.filter_type_menu,'String');
        filter_str = filter_str{get(handles.filter_type_menu,'Value')};
        handles.filter = fspecial(filter_str,handles.neighbor,handles.sigma);
    case 2
        set(handles.filter_param_menu,'Value',handles.radius);
        set(handles.filter_param_menu,'Visible','on');
        set(handles.filter_param_menu,'String',handles.filter_param_menu_string_neighbor);
        set(handles.filter_param_menu,'TooltipString',...
            'Radius of the circular averaging filter (Pillbox).');
        set(handles.filter_param_txt,'Visible','on');
        set(handles.filter_param_txt,'String','Radius');
        set(handles.filter_type_edit_txt,'Visible','off');
        set(handles.filter_type_opt_txt,'Visible','off');
        radius = str2num(handles.filter_param_menu_string_neighbor{handles.radius});
        filter_str = get(handles.filter_type_menu,'String');
        filter_str = filter_str{get(handles.filter_type_menu,'Value')};
        handles.filter = fspecial(filter_str,radius);
    case {4,9}
        set(handles.filter_param_menu,'Value',handles.alpha);
        set(handles.filter_param_menu,'Visible','on');
        set(handles.filter_param_menu,'String',handles.filter_param_menu_str_alpha);
        set(handles.filter_param_menu,'TooltipString',...
            'Alpha controls the shape of the Laplacian and must be in the range 0.0 to 1.0.');
        set(handles.filter_param_txt,'Visible','on');
        set(handles.filter_param_txt,'String','Alpha');
        set(handles.filter_type_edit_txt,'Visible','off');
        set(handles.filter_type_opt_txt,'Visible','off');
        alpha = str2num(handles.filter_param_menu_str_alpha{handles.alpha});
        filter_str = get(handles.filter_type_menu,'String');
        filter_str = filter_str{get(handles.filter_type_menu,'Value')};
        handles.filter = fspecial(filter_str,alpha);
    case 6
        set(handles.filter_param_menu,'Value',handles.len);
        set(handles.filter_param_menu,'Visible','on');
        set(handles.filter_param_menu,'String',handles.filter_param_menu_string_neighbor);
        set(handles.filter_param_menu,'TooltipString',...
            'Convolve the image to create the linear motion of a camera by length pixels');
        set(handles.filter_param_txt,'Visible','on');
        set(handles.filter_param_txt,'String','Length');
        set(handles.filter_type_opt_txt,'Visible','on');
        set(handles.filter_type_edit_txt,'Visible','on');
        set(handles.filter_type_opt_txt,'String','Theta');
        set(handles.filter_type_edit_txt,'Value',handles.theta);
        set(handles.filter_type_edit_txt,'String',num2str(handles.theta));
        set(handles.filter_type_edit_txt,'TooltipString',...
            'Theta is the angle of motion, 0 = horizontal.');
        set(handles.filter_type_edit_txt,'Visible','on');
        set(handles.filter_type_opt_txt,'Visible','on');
        len = str2num(handles.filter_param_menu_string_neighbor{handles.len});
        filter_str = get(handles.filter_type_menu,'String');
        filter_str = filter_str{get(handles.filter_type_menu,'Value')};
        handles.filter = fspecial(filter_str,len,handles.theta);
    case {7,8}
        set(handles.filter_param_menu,'Visible','off');
        set(handles.filter_param_txt,'Visible','off');
        set(handles.filter_type_edit_txt,'Visible','off');
        set(handles.filter_type_opt_txt,'Visible','off');
        filter_str = get(handles.filter_type_menu,'String');
        filter_str = filter_str{get(handles.filter_type_menu,'Value')};
        handles.filter = fspecial(filter_str);
end
%show preview
handles.demo_img = imfilter(handles.orig_img,handles.filter,handles.boundary_str,handles.filter_opt_str,'same');
%extend the dynamic range
if get(handles.gain_box,'Value')
    handles.demo_img = rangemax(handles.demo_img,handles.new_lim,handles.old_lim);
end
axes(handles.filtered)
image(handles.img_width,handles.img_length,handles.demo_img);
colormap(gray(256));
set(handles.filtered,'Visible','off','Units','pixels');

% Update handles structure
guidata(hObject, handles);

% --- Executes during object creation, after setting all properties.
function filter_type_menu_CreateFcn(hObject, eventdata, handles)
% hObject    handle to filter_type_menu (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on selection change in boundary_menu.
function boundary_menu_Callback(hObject, eventdata, handles)
% hObject    handle to boundary_menu (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = get(hObject,'String') returns boundary_menu contents as cell array
%        contents{get(hObject,'Value')} returns selected item from boundary_menu
if get(hObject,'Value')==1
    set(handles.boundary_edit_txt,'Visible','on');
    handles.boundary_str = handles.boundary;
else
    set(handles.boundary_edit_txt,'Visible','off');
    handles.boundary_str = get(handles.boundary_menu,'String');
    handles.boundary_str = handles.boundary_str{get(handles.boundary_menu,'Value')};
end

%show preview
handles.demo_img = imfilter(handles.orig_img,handles.filter,handles.boundary_str,handles.filter_opt_str,'same');
%extend the dynamic range
if get(handles.gain_box,'Value')
    handles.demo_img = rangemax(handles.demo_img,handles.new_lim,handles.old_lim);
end
axes(handles.filtered)
image(handles.img_width,handles.img_length,handles.demo_img);
colormap(gray(256));
set(handles.filtered,'Visible','off','Units','pixels');

% Update handles structure
guidata(hObject, handles);

% --- Executes during object creation, after setting all properties.
function boundary_menu_CreateFcn(hObject, eventdata, handles)
% hObject    handle to boundary_menu (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on selection change in filter_opt_menu.
function filter_opt_menu_Callback(hObject, eventdata, handles)
% hObject    handle to filter_opt_menu (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = get(hObject,'String') returns filter_opt_menu contents as cell array
%        contents{get(hObject,'Value')} returns selected item from filter_opt_menu
handles.filter_opt_str = get(handles.filter_opt_menu,'String');
handles.filter_opt_str = handles.filter_opt_str{get(handles.filter_opt_menu,'Value')};
%show preview
handles.demo_img = imfilter(handles.orig_img,handles.filter,handles.boundary_str,handles.filter_opt_str,'same');
%extend the dynamic range
if get(handles.gain_box,'Value')
    handles.demo_img = rangemax(handles.demo_img,handles.new_lim,handles.old_lim);
end
axes(handles.filtered)
image(handles.img_width,handles.img_length,handles.demo_img);
colormap(gray(256));
set(handles.filtered,'Visible','off','Units','pixels');

% Update handles structure
guidata(hObject, handles);

% --- Executes during object creation, after setting all properties.
function filter_opt_menu_CreateFcn(hObject, eventdata, handles)
% hObject    handle to filter_opt_menu (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function boundary_edit_txt_Callback(hObject, eventdata, handles)
% hObject    handle to boundary_edit_txt (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of boundary_edit_txt as text
%        str2double(get(hObject,'String')) returns contents of boundary_edit_txt as a double
handles.boundary = str2double(get(hObject,'String'));
handles.boundary_str = handles.boundary;
%show preview
handles.demo_img = imfilter(handles.orig_img,handles.filter,handles.boundary_str,handles.filter_opt_str,'same');
%extend the dynamic range
if get(handles.gain_box,'Value')
    handles.demo_img = rangemax(handles.demo_img,handles.new_lim,handles.old_lim);
end
axes(handles.filtered)
image(handles.img_width,handles.img_length,handles.demo_img);
colormap(gray(256));
set(handles.filtered,'Visible','off','Units','pixels');

% Update handles structure
guidata(hObject, handles);

% --- Executes during object creation, after setting all properties.
function boundary_edit_txt_CreateFcn(hObject, eventdata, handles)
% hObject    handle to boundary_edit_txt (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end





function filter_type_edit_txt_Callback(hObject, eventdata, handles)
% hObject    handle to filter_type_edit_txt (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of filter_type_edit_txt as text
%        str2double(get(hObject,'String')) returns contents of
%        filter_type_edit_txt as a double
switch get(handles.filter_type_opt_txt,'String')
    case 'sigma'
        handles.sigma = str2double(get(hObject,'String'));
        filter_str = get(handles.filter_type_menu,'String');
        filter_str = filter_str{get(handles.filter_type_menu,'Value')};
        handles.filter = fspecial(filter_str,handles.len,handles.sigma);
    case 'theta'
        handles.theta = str2double(get(hObject,'String'));
        filter_str = get(handles.filter_type_menu,'String');
        filter_str = filter_str{get(handles.filter_type_menu,'Value')};
        handles.filter = fspecial(filter_str,handles.len,handles.theta);
end
%show preview
handles.demo_img = imfilter(handles.orig_img,handles.filter,handles.boundary_str,handles.filter_opt_str,'same');
%extend the dynamic range
if get(handles.gain_box,'Value')
    handles.demo_img = rangemax(handles.demo_img,handles.new_lim,handles.old_lim);
end
axes(handles.filtered)
image(handles.img_width,handles.img_length,handles.demo_img);
colormap(gray(256));
set(handles.filtered,'Visible','off','Units','pixels');

% Update handles structure
guidata(hObject, handles);

% --- Executes during object creation, after setting all properties.
function filter_type_edit_txt_CreateFcn(hObject, eventdata, handles)
% hObject    handle to filter_type_edit_txt (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


